#include "IRremote.h"
#include "IR.h"

IRrecv irrecv(RECEIVER);
decode_results results;

int ledRed = 10;
int ledGreen = 9;
int ledBlue = 8;

void setup() {
  
  Serial.begin(9600);
  Serial.println("IR gestartet.");
  irrecv.enableIRIn();
  pinMode(ledRed, OUTPUT);
  pinMode(ledGreen, OUTPUT);
  pinMode(ledRed, OUTPUT);
}

void loop() {
  
  if (irrecv.decode(&results)) {

    switch (results.value) {
      case 0xFF6897:
        Serial.println("0");
        digitalWrite(ledRed, LOW);
        digitalWrite(ledGreen, LOW);
        digitalWrite(ledBlue, LOW);
        break;
      case 0xFF30CF:
        Serial.println("1");
        digitalWrite(ledRed, HIGH);
        digitalWrite(ledGreen, LOW);
        digitalWrite(ledBlue, LOW);
        break;
      case 0xFF18E7:
        Serial.println("2");
        digitalWrite(ledRed, LOW);
        digitalWrite(ledGreen, HIGH);
        digitalWrite(ledBlue, LOW);
        break;
      case 0xFF7A85:
        Serial.println("3");
        digitalWrite(ledRed, LOW);
        digitalWrite(ledGreen, LOW);
        digitalWrite(ledBlue, HIGH);
        break;
    }
    irrecv.resume();
  }
}
